# Quick Start — Deploy in 10 Minutes

## You'll Need
- [ ] Node.js installed ([download](https://nodejs.org/))
- [ ] AssemblyAI API key ([get one free](https://www.assemblyai.com/))
- [ ] Vercel account ([sign up free](https://vercel.com/))

---

## Commands to Run

Open terminal in the unzipped `coaching-feedback-app` folder, then:

```bash
# 1. Install Vercel (one time only)
npm install -g vercel

# 2. Deploy
vercel

# 3. Add your AssemblyAI API key
vercel env add ASSEMBLYAI_API_KEY
# → Paste your key, select all environments

# 4. Add access codes for students
vercel env add ACCESS_CODES
# → Enter codes like: coach2024,winter2025
# → Select all environments

# 5. Deploy to production
vercel --prod
```

---

## Done!

Your app is live at: `https://[your-project-name].vercel.app`

Give students:
1. The URL
2. An access code

---

## Later: Change Access Codes

1. Go to vercel.com/dashboard
2. Click your project → Settings → Environment Variables
3. Edit `ACCESS_CODES`
4. Save and redeploy

---

## Costs

~$0.45 per 1-hour session (AssemblyAI)
Hosting is free (Vercel)
